/** JS Document
 * Created By 潘正龙 2018-07-31 version1.0 原生JS创建全局通用方法和类等*
 * Modified By 潘正龙 2018-09-14 version1.1 修改为兼容angular框架的原生组件js
 * Modified By 潘正龙 2018-09-19 version1.2 修改为钻取方法
**/

// 逻辑
var EchartsOptionsInit = {
	init:function(catalog, type, children, dom, drilling){
		var option = {
			title: {},
			textStyle: {
				fontStyle:'normal'
			},
			tooltip : {},
			legend: {data:[]},
			toolbox: {
				feature: {
					saveAsImage: {}
				}
			},
			grid: {
				left: '3%',
				right: '4%',
				bottom: '3%',
				containLabel: true
			},
			xAxis: {
				type: 'category',
				data: []
			},
			yAxis: {
				type: 'value'
			},
			series: []
		};
		if(catalog == 'line'){ // 折线类型的数据初始化
		    option.title = {
				show:false,
				subtext:'折线图副标题',
				text:'折线图主标题',
				x: 'center',                 // 水平安放位置，默认为左对齐，可选为：
										   // 'center' ¦ 'left' ¦ 'right'
										   // ¦ {number}（x坐标，单位px）
				y: 'top',                  // 垂直安放位置，默认为全图顶端，可选为：
										   // 'top' ¦ 'bottom' ¦ 'center'
										   // ¦ {number}（y坐标，单位px）
				//textAlign: null          // 水平对齐方式，默认根据x设置自动调整
				backgroundColor: 'rgba(0,0,0,0)',
				borderColor: '#ccc',       // 标题边框颜色
				borderWidth: 0,            // 标题边框线宽，单位px，默认为0（无边框）
				padding: 5,                // 标题内边距，单位px，默认各方向内边距为5，
										   // 接受数组分别设定上右下左边距，同css
				itemGap: 10,               // 主副标题纵向间隔，单位px，默认为10，
				textStyle: {
					fontSize: 18,
					fontWeight: 'bolder',
					color: '#333',          // 主标题文字颜色
					fontStyle:'italic'
				},
				subtextStyle: {
					color: '#aaa'          // 副标题文字颜色
				}
			};
			option.tooltip = {
				trigger: 'axis',
				axisPointer: {
					type: 'cross',
					label: {
						backgroundColor: '#6a7985'
					}
				}
			};
			option.toolbox = {
				show: true,
				orient: 'vertical',
				left: 'right',
				top: 'center',
				feature: {
					mark: {show: true},
					magicType: {show: true, type: ['line', 'bar']},
					restore: {show: true},
					saveAsImage: {show: true}
				}
            };
		}else if(catalog == 'bar'){
		    option.title = {
				text: 'Bar条图',
                subtext: 'Bar条图分类'
			};
			option.tooltip = {
				trigger: 'axis',
				axisPointer: {
					type: 'shadow'
				}
			};
			option.xAxis = {data:[]};
			option.toolbox = {
				show: true,
				orient: 'vertical',
				left: 'right',
				top: 'center',
				feature: {
					mark: {show: true},
					dataView: {show: true, readOnly: false},
					magicType: {show: true, type: ['line', 'bar', 'stack', 'tiled']},
					restore: {show: true},
					saveAsImage: {show: true}
				}
            };
		}else if(catalog == 'pie'){ // 饼状图
			option.title = {text:'饼状图演示',subtext:'纯属虚构',x:'center'};
			option.tooltip = {trigger:'item',formatter:"{a} <br/>{b} : {c} ({d}%)"};
			option.toolbox = {
				show: false,
				orient: 'vertical',
				left: 'right',
				top: 'center',
				feature: {
					mark: {show: true},
					dataView: {show: true, readOnly: false},
					magicType: {show: true, type: ['line', 'bar', 'stack', 'tiled']},
					restore: {show: true},
					saveAsImage: {show: true}
				}
            };
			delete option.grid;
			delete option.xAxis;
			delete option.yAxis;
		}else if(catalog == 'radar'){
			option.radar = [{indicator:[],name:{normal:{}}}];
			delete option.grid;
			delete option.xAxis;
			delete option.yAxis;
			option.toolbox = {
				show: false,
				orient: 'vertical',
				left: 'right',
				top: 'center',
				feature: {
					mark: {show: true},
					dataView: {show: true, readOnly: false},
					saveAsImage: {show: true}
				}
            };
		}else if(catalog == 'sankey'){ /**2018-10-24 新增桑基图方法开始**/
			option.title = {show:false,x:'center',y:'top'};
			option.tooltip = {trigger:'item',triggerOn:'mousemove'};
			option.toolbox = {
				show:true,
				orient: 'vertical',
				left: 'right',
				top: 'center',
				feature: {
				  saveAsImage: {show: true}
				}
			};
			delete option.grid;
			delete option.xAxis;
			delete option.yAxis;
        }; /**2018-10-24 新增桑基图方法结束**/
        EchartsOptionsInit.assign(catalog, type, children, option, dom, drilling);
	},
	assign:function(catalog, type, children, option, dom, drilling){ /*两个对象合并*/
		if(!!children.params){ // 有自定义选项
		    var params = children.params;
			for (var obj in params){
				if(option.hasOwnProperty(obj) && params.hasOwnProperty(obj)){
					option[obj] = Object.assign(option[obj],params[obj]);
				}else if(params.hasOwnProperty(obj) && !option.hasOwnProperty(obj)){
					option[obj] = params[obj];
				}else if(!params.hasOwnProperty(obj) && option.hasOwnProperty(obj)){
					option[obj] = option[obj];
				}
			}
			if(!children.params.legend){
				option.legend.show = false;
			}else{
				option.legend.show = true;
			}
			if(!children.params.toolbox){
				option.toolbox.show = false;
			}else{
				option.toolbox.show = true;
			}
			if(!children.params.title){
				option.title.show = false;
			}else{
				option.title.show = true;
			}
			if(!!children.params.legend){ //  重新定义legend参数
				option.legend = Object.assign(option.legend,children.params.legend);
			}
		}
		if(!!children.X){ // X轴数据
			if(children.X.length){ // X轴回来的是数组
				option.xAxis = children.X;
			}else if(!children.X.length){
				option.xAxis = Object.assign(option.xAxis,children.X);
			}
		}
		if(!!children.Y){ // Y轴数据
			if(children.Y.length){ // Y轴回来的是数组
				option.yAxis = children.Y;
			}else if(!children.Y.length){
				option.yAxis = Object.assign(option.yAxis,children.Y);
			}
		}
		if(!!children.data){ // 数据部分
			var data = children.data
			if(catalog == 'line'){ // 线图
				if(!!children.params){

				}
			}else if(catalog == 'bar'){ // bar条图且带缩放
			    if(!!children.params){ // 定义Bar条的颜色
					if(!!children.params.BarColors){
						option.color = children.params.BarColors;
					}
					if(!!children.params.yAxis){
						if(type == 'mixlinebar' || type == 'multipleyaxis'){ // 线图和Bar图混合图 或者多轴图
							option.yAxis = []
							for(var k=0;k<children.params.yAxis.length;k++){
								var Y = children.params.yAxis[k];
								option.yAxis[k] = {};
								if(!!children.params.BarColors){
									option.yAxis[k].axisLine = {lineStyle:{color:children.params.BarColors[k]}};
								}
								for(var obj in Y){
									if(obj == 'formatter'){
										option.yAxis[k] = Object.assign(option.yAxis[k],{axisLabel:{formatter:'{value}' +Y.formatter}});
									}else if(obj == 'LineColor'){
										option.yAxis[k] = Object.assign(option.yAxis[k],{axisLine:{lineStyle:{color:Y.LineColor}}});
									}else{
										option.yAxis[k][obj] = Y[obj];
									}
								}
								option.yAxis[k] = Object.assign(option.yAxis[k],{type:'value',min:0});
							}
						}
					}
					if(type == 'mixzoomonvalue' && !children.params.dataZoom){ // 可区域滑动
						option.dataZoom = [{show:true,start:94,end:100},{type:'inside',start:94,end:100},{show:true,yAxisIndex:0,filterMode:'empty',width:30,height:'80%',showDataShadow:false,left:'93%'}];
					}
					if(type == 'stack' && !!children.params.markLine){ // stack 定义最高点
					    option.stackArray = [];
				    }
					if(type == 'mixlinebar'){ // 线图和Bar图混合图
						delete option.tooltip;
					    if(!!children.params.tooltip){
							option.tooltip = {trigger:'axis',axisPointer:{type:'cross',crossStyle:{color:'#999'}}};
						}else{
							option.tooltip = {};
						}
						if(!!children.params.toolbox){
							option.toolbox = {feature:{dataView:{show:true,readOnly:false},magicType:{show:true,type:['line','bar']},restore:{show:true},saveAsImage:{show:true}}};
						}else{
							option.toolbox.show = false;
						}
					}
				}
			    if(type == 'gradient'){ // 手势缩放
					children.params.gradient = option.series;
					option.xAxis = Object.assign({axisLabel:{inside:true,textStyle:{color:'#fff'}},axisTick:{show: false},axisLine:{show:false},z:10},option.xAxis);
					option.yAxis = Object.assign({axisLine:{show:false},axisTick:{show:false},axisLabel:{textStyle: {color: '#999'}}},option.yAxis);
					option.dataZoom = {type:'inside'}
				}else if(type == 'labelrotation'){ // bar条文字缩放
				    // 定义位置参数
					option.posList = ['left','right','top','bottom','inside','insideTop','insideLeft','insideRight','insideBottom','insideTopLeft','insideTopRight','insideBottomLeft', 'insideBottomRight'];
					// 定义默认config
					option.app = {};
					option.app.configParameters={rotate:{min:-90,max:90},align:{options:{left:"left",center:"center",right:"right"}},verticalAlign:{options:{top:"top",middle:"middle",bottom:"bottom"}},position:{options:echarts.util.reduce(option.posList,function(map,pos){map[pos]=pos;return map},{})},distance:{min:0,max:100}};
					option.app.config={rotate:90,align:"left",verticalAlign:"middle",position:"insideBottom",distance:15,onChange:function(){var labelOption={normal:{rotate:option.app.config.rotate,align:option.app.config.align,verticalAlign:option.app.config.verticalAlign,position:option.app.config.position,distance:option.app.config.distance}};myChart.setOption({series:[{label:labelOption},{label:labelOption},{label:labelOption},{label:labelOption}]})}};
					option.labelOption={normal:{show:true,position:option.app.config.position,distance:option.app.config.distance,align:option.app.config.align,verticalAlign:option.app.config.verticalAlign,rotate:option.app.config.rotate,formatter:"{c}  {name|{a}}",fontSize:16,rich:{name:{textBorderColor:"#fff"}}}};
					option.calculable = true;
				}else if(type == 'richtext'){ // 富文本横向条状图
					option.xAxis={type:"value",axisLabel:{formatter:"{value}"}};
					if(!!children.params.markPoint){
						option.xAxis.name = children.params.markPoint.name;
					}
					option.yAxis={type:"category",inverse:true,data:[],axisLabel:{formatter:function(value){return"{"+value+"| }\n{value|"+value+"}"},margin:20,rich:{value:{lineHeight:30,align:"center"}}}};
					option.seriesLabel={normal:{show:true,textBorderColor:"#333",textBorderWidth:2}};
					for (var obj in children.params.Icons){
						option.yAxis.data.push(obj);
						option.yAxis.axisLabel.rich[obj] = {height:40,align:'center',backgroundColor:{image:children.params.Icons[obj]}};
					}
				}else if(type == 'ycategory'){ // ycategory  Y轴展示数据
					option.xAxis = {type:'value',boundaryGap:[0, 0.01]};
					option.yAxis = Object.assign(option.yAxis,{type:'category',data:[]});
				}else if(type == 'ycategorystack'){ // 堆叠条形图复合型
					option.xAxis = {type:'value'};
					option.yAxis = {type:'category',data:[]};
				}else if(type == 'bar1'){ // 最低点和最高点
					option.calculable = true;
					option.xAxis = Object.assign(option.xAxis,{type:'category',data:[]});
				}else if(type == 'mixlinebar'){ // 线图和Bar图混合图
					option.xAxis = Object.assign(option.xAxis,{type:'category',axisPointer:{type:'shadow'},data:[]});
				}else if(type == 'mixzoomonvalue'){ // 可区域滑动
					option.tooltip = Object.assign(option.tooltip,{axisPointer:{type:'shadow',label:{show:true}}});
					option.calculable = true;
					option.grid = {top:'12%',left: '1%',right: '10%',containLabel:true};
					option.legend = {data:['Growth'],itemGap: 5};
					option.xAxis = Object.assign(option.xAxis,{type:'category'});
					option.yAxis = Object.assign(option.yAxis,{type:'value',axisLabel:{formatter:function(a){a=+a;return isFinite(a)?echarts.format.addCommas(+a / 1000):'';}}});
				}else if(type == 'multipleyaxis'){ // Y轴多参数
				    option.tooltip = Object.assign(option.tooltip,{axisPointer:{type:'cross'}});
					option.grid = Object.assign(option.grid,{right:'10%'});
					option.xAxis = Object.assign(option.xAxis,{type:'category',data:[],axisTick:{alignWithLabel:true}});
				}
			}else if(catalog == 'pie'){ // 饼状
			    if(type == 'doughnut'){ // 环形饼图
					option.legend = Object.assign(option.legend,{orient:'vertical',left:'left'});
				}else if(type == 'legend'){ // 饼状全型图
					option.legend = Object.assign(option.legend,{type:'scroll',orient:'vertical',right:10,top:100,bottom:20});
				}else if(type == 'nest'){ // 双类型饼图
					option.legend = Object.assign(option.legend,{orient:'vertical',left:'left'});
				}else if(type == 'richtext'){ // 带富文本类型饼图
					option.legend = Object.assign(option.legend,{bottom:10,left:'center'});
				}else if(type == 'roseType'){ // 南丁格尔玫瑰图
					option.legend = Object.assign(option.legend,{x:'center',y :'bottom'});
					option.toolbox.feature = {mark:{show:true},dataView:{show:true,readOnly:false},magicType:{show:true,type:['pie','funnel']},restore:{show:true},saveAsImage:{show: true}};
				}
			}else if(catalog == 'radar'){ // 雷达图
				if(type == 'demo'){ // 默认雷达图

				}
				if(!!children.params){ //  重新定义legend参数
					if(!!children.params.radar){
					    for(var y=0;y<children.params.radar.length;y++){
							option.radar[y] = {name:{},splitArea:{}};
							var Radar = children.params.radar[y];
							if(!!Radar.Postion){ // 位置
								option.radar[y].center = Radar.Postion;
							}
							if(!!Radar.Size){ // 大小
								option.radar[y].radius = Radar.Size;
							}
							if(!!Radar.Rotate){ // 雷达旋转
								option.radar[y].startAngle = Radar.Rotate;
							}
							if(!!Radar.CircleLineNo){ // 雷达环线的个数
								option.radar[y].splitNumber = Radar.CircleLineNo;
							}
							if(!!Radar.Shape){ // 雷达图的形状
								option.radar[y].shape = Radar.Shape;
							}
							if(!!Radar.NameFormatter){ // 节点表现形式
								option.radar[y].name.formatter = Radar.NameFormatter;
							}
							if(!!Radar.NameStyle){ // 节点表现形式
								option.radar[y].name.textStyle = Radar.NameStyle;
							}
							if(!!Radar.AreaColors){ // 环形图的背景颜色
								option.radar[y].splitArea = {areaStyle:{color:Radar.AreaColors}};
							}
							if(!!Radar.AxisLineColor){ // 轴线的颜色
								option.radar[y].axisLine = {lineStyle:{color:Radar.AxisLineColor}};
							}
							if(!!Radar.CircleLineColor){ // 轴线的颜色
								option.radar[y].splitLine = {lineStyle:{color:Radar.CircleLineColor}};
							}
						}
					}
				}
			}else if(catalog == 'sankey'){ /**2018-10-24 新增桑基图方法开始**/
			    option.series[0] = {};
			    option.series[0].links = data.links; // 节点连接
				option.series[0].data = data.nodes; // 节点名称
				option.series[0].type = catalog;
				option.series[0].layout = 'none';
				if(!!children.params && !!children.params.focusNodeAdjacency){
				    option.series[0].focusNodeAdjacency = children.params.focusNodeAdjacency;
				}else{
				    option.series[0].focusNodeAdjacency = false;
				}
				option.series[0].itemStyle = {normal:{borderWidth:1,borderColor:'#aaa'}};
				option.series[0].lineStyle = {normal:{curveness:0.5}};
				if(type == 'simple'){ // 默认桑基图

				}else if(type == 'vertical'){ // 竖向桑基图
				    option.series[0].orient = 'vertical';
				    option.series[0].label = {position:'top'};
				    option.series[0].lineStyle = {normal:{color:'source',curveness:0.5}};
				}
			}; /**2018-10-24 新增桑基图方法结束**/
			for(var i=0;i<data.length;i++){
				option.series[i] = {};
				for (var obj in data[i]){
					if(data[i][obj] instanceof Array){ // 内部数据要取值
					    if(typeof(data[i][obj][0]) == 'number' || typeof(data[i][obj][1]) == 'number'){ // 判断array的首个对象是数字
							option.series[i].data = data[i][obj]
						}else if(typeof(data[i][obj][0]) == 'object' || typeof(data[i][obj][1]) == 'object'){ // 判断array的首个对象是object
							var newArray = []
							for(var k=0;k<data[i][obj].length;k++){
								for(var m in data[i][obj][k]){
									if(/^[0-9]*$/i.test(data[i][obj][k][m].toString().replace(/\./g,'')) && typeof(parseInt(data[i][obj][k][m])) == 'number'){
										newArray.push(parseFloat(data[i][obj][k][m]))
									}else{
										if(catalog == 'line'){ // 线图
											option.xAxis.data.push(data[i][obj][k][m]);
											if(i == data.length - 1){
												option.xAxis.data = Array.from(new Set(option.xAxis.data))
											}
										}else if(catalog == 'bar'){ // 柱状图
											if(type == 'ycategory'){ // ycategory  Y轴展示数据,
												option.yAxis.data.push(data[i][obj][k][m])
											}else if(type == 'ycategorystack'){
												option.yAxis.data.push(data[i][obj][k][m]);
												if(i == data.length - 1){
													option.yAxis.data = Array.from(new Set(option.yAxis.data))
												}
											}else if(type == 'bar1' || type == 'mixlinebar' || type == 'multipleyaxis' || type == 'gradient' || type == 'tickalign'){ // bar1带有高低值
												option.xAxis.data.push(data[i][obj][k][m])
											}else if(type == 'simple' || type == 'labelrotation' || type == 'stack'){
												option.xAxis.data.push(data[i][obj][k][m]);
												if(i == data.length - 1){
													option.xAxis.data = Array.from(new Set(option.xAxis.data))

												}
											}
										}
									}
								}
							}
							option.series[i].data = newArray
						}
					}else if(typeof(data[i][obj]) == 'string' || typeof(data[i][obj]) == 'number'){ //
						option.series[i].name = data[i][obj];
						option.legend.data.push(data[i][obj])
					}
				}
				option.series[i].type = catalog
				if(catalog == 'line'){ // 折线图
					if(!!data[i].name){ // legend
						option.legend.data.push(data[i].name)
						option.series[i].name = data[i].name
					}
					if(type == 'smooth'){
						option.series[i].smooth = true
					}
					if(type == 'areastack' || type == 'stack'){
						option.series[i].stack = data[i].stack
						if(!!children.params){
							if(!!children.params.label){
								option.series[i].label = children.params.label
							}
						}
					}
					if(!!children.params.AreaColors){
						option.series[i].areaStyle = {color:[children.params.AreaColors[i]]} || {normal: {}}
					}
					if(!!children.params.lineStyle){
						//option.series[i].lineStyle = children.params.lineStyle
					}
				}else if(catalog == 'bar'){ // bar条图
					if(!!data[i].name){ // legend
						option.legend.data.push(data[i].name);
						option.series[i].name = data[i].name;
						if(i == data.length - 1){
							option.legend.data = Array.from(new Set(option.legend.data))
						}
					}
					if(!!children.params){
						if(!!children.params.BarWidth){ // 定义Bar条的宽度
							if(typeof(children.params.BarWidth) == 'number' || typeof(children.params.BarWidth) == 'string'){
								option.series[i].barWidth = children.params.BarWidth
							}else if(typeof(children.params.BarWidth) == 'object'){
								option.series[i].barWidth = children.params.BarWidth[i]
							}
						}
					}
					if(type == 'gradient' && i==0){ // 手势缩放
					    option.series[1] = JSON.parse(JSON.stringify(option.series[0]));
					    option.series[0] = {data:[],barGap:'-100%',barCategoryGap:'40%',animation:false,type:catalog};
						var max = parseInt(Math.max(...option.series[1].data));
					    for(var n=0;n<option.series[1].data.length;n++){
							option.series[0].data.push(max + Math.pow(10,parseInt(max).toString().length - 1))
						}
					}else if(type=='labelrotation'){// bar条文字旋转
					    option.series[i].label = option.labelOption;
					    if(i==0){
							option.series[i].barGap = 0
						}else if(i == data.length - 1){
							option.legend.data = Array.from(new Set(option.legend.data))
						}
					}else if(type == 'richtext'){ // 富文本横向条状图
						option.series[i].label = option.seriesLabel;
						if(!!children.params.markPoint && children.params.markPoint.mark == i){
							option.series[i].markPoint={symbolSize:1,symbolOffset:[0,"50%"],label:{normal:{formatter:"{a|{a}\n}{b|{b} }{c|{c}}",backgroundColor:"rgb(242,242,242)",borderColor:"#aaa",borderWidth:1,borderRadius:4,padding:[4,10],lineHeight:26,position:"right",distance:20,rich:{a:{align:"center",color:"#fff",fontSize:18,textShadowBlur:2,textShadowColor:"#000",textShadowOffsetX:0,textShadowOffsetY:1,textBorderColor:"#333",textBorderWidth:2},b:{color:"#333"},c:{color:"#ff8811",textBorderColor:"#000",textBorderWidth:1,fontSize:22}}}},data:[{type:"max",name:"max "+children.params.markPoint.name+": "},{type:"min",name:"min "+children.params.markPoint.name+": "}]};
					    }
					}else if(type == 'stack' || type == 'ycategorystack'){ // 堆叠柱状图
						if(!!data[i].stack){ // 分类
							option.series[i].stack = data[i].stack
						}
						if(!!children.params){
							if(!!children.params.label){ // ycategorystack
								option.series[i].label = {normal:{show:true,position: 'insideRight'}}
							}
							if(!!children.params.markLine){ // stack 定义最高点
							    option.stackArray.push(option.series[i].data)
								if(i == data.length - 1){
									var NewArray = []
									for(var k=0;k<option.stackArray.length;k++){
										NewArray.push(Math.max(...option.stackArray[k]))
									}
									for(var m=0;m<NewArray.length;m++){
										if(NewArray[m] == Math.max(...NewArray)){
											option.series[m].markLine = {lineStyle:{normal:{type:'dashed'}},data:[[{type:'min'},{type:'max'}]]};
											delete option.markLine;
											delete option.stackArray
										}
									}
								}
							}
						}
					}else if(type == 'ycategory' || type == 'bar1' || type == 'mixlinebar' || type == 'multipleyaxis'){
					// ycategory  Y轴展示数据,bar1带有高低值, mixlinebar 线条混合图, multipleyaxis多轴图
						if(type == 'bar1'){ // bar1带有高低值
							if(!!children.params){
								if(!!children.params.average){
									option.series[i].markLine={data:[{type:'average',name:'平均值'}]}
								}
								if(!!children.params.min){
									if(!option.series[i].markPoint){
										option.series[i].markPoint = {data:[]}
									}
									option.series[i].markPoint.data.push({type:'min',name:'最小值'})
								}
								if(!!children.params.max){
									if(!option.series[i].markPoint){
										option.series[i].markPoint = {data:[]}
									}
									option.series[i].markPoint.data.push({type:'max',name:'最大值'})
								}
							}
							if(i == data.length - 1){
								option.xAxis.data = Array.from(new Set(option.xAxis.data))
							}
						}else if(type == 'ycategory'){ // ycategory  Y轴展示数据,
							if(i == data.length - 1){
								option.yAxis.data = Array.from(new Set(option.yAxis.data))
							}
						}else if(type == 'mixlinebar'){ // mixlinebar 线条混合图
							if(i == data.length - 1){
								option.xAxis.data = Array.from(new Set(option.xAxis.data));
								option.series[i].type = 'line';
								option.series[i].yAxisIndex = 1
							}
						}else if(type == 'multipleyaxis'){ // 多轴图
						    option.yAxis[i].position = 'right';
							if(i == data.length - 1){
								option.yAxis[i].position = 'left';
							    option.xAxis.data = Array.from(new Set(option.xAxis.data));
								option.series[i].type = 'line';
								option.series[i].yAxisIndex = 2;
								var MaxList = [];
								for(var n=0;n<option.series.length;n++){
									var max = parseInt(Math.max(...option.series[n].data));
									option.yAxis[n].max = max + Math.pow(10,parseInt(max).toString().length - 1);
									if(n < option.series.length - 1){
										MaxList.push(option.yAxis[n].max)
									}
								}
								for(var p=0;p<MaxList.length;p++){
									option.yAxis[p].max = Math.max(...MaxList)
								}
							}
						}
					}
				}else if(catalog == 'pie'){ // 饼状图
					option.series[i] = data[i];
					option.series[i].type = catalog;
					option.series[i].itemStyle = {emphasis: {shadowBlur:10,shadowOffsetX:0,shadowColor: 'rgba(0, 0, 0, 0.5)'}};
					var PieConfig = [];
					if(type == 'doughnut'){ // 环形饼状图
						PieConfig.push({radius: ['50%','70%'],avoidLabelOverlap:false,label:{normal:{show:false,position:'center',textStyle:{fontSize:'18',fontWeight:'normal'}},emphasis:{show:true,textStyle:{fontSize:'20',fontWeight:'bold'}}},labelLine:{normal:{show:false}}})
					}else if(type == 'legend'){ // 饼状全型图
						PieConfig.push({radius:'50%',center:['40%','60%'],itemStyle:{emphasis:{shadowBlur:10,shadowOffsetX:0,shadowColor: 'rgba(0, 0, 0, 0.5)'}}})
					}else if(type == 'nest'){ // 双类型饼图
						PieConfig = [{/*selectedMode:"single",*/radius:[0,"30%"],label:{normal:{position:"inner"}},labelLine:{normal:{show:false}}},{radius:["40%","55%"],label:{normal:{formatter:"{a|{a}}{abg|}\n{hr|}\n  {b|{b}：}{c}  {per|{d}%}  ",backgroundColor:"#eee",borderColor:"#aaa",borderWidth:1,borderRadius:4,shadowBlur:3,shadowOffsetX:2,shadowOffsetY:2,shadowColor:"#999",rich:{a:{color:"#999",lineHeight:22,align:"center"},hr:{borderColor:"#aaa",width:"100%",borderWidth:0.5,height:0},b:{fontSize:16,lineHeight:33},per:{color:"#eee",backgroundColor:"#334455",padding:[2,4],borderRadius:2}}}}}];
						if(i == data.length - 1){
							for(var n=0;n<option.series[0].data.length;n++){
								for(var l=0;l<option.series[1].data.length;l++){
									if(pgyBase.ObjEqual(option.series[0].data[n], option.series[1].data[l])){
										option.series[0].data[n].selected = true
									}
								}
							}
						}
					}else if(type == 'roseType'){ //  南丁格尔玫瑰图
					    PieConfig[i] = {radius:[0,150],center:['50%','50%']}
					}
					option.series[i] = Object.assign(option.series[i],PieConfig[i]);
					if(!children.params.label && children.params.label == false){ // 是否显示标签和线
						option.series[i].label = {normal:{show:false},emphasis:{show:false}}
					}
					if(!!children.params.PieConfig){ // 自定义参数
						option.series[i] = Object.assign(option.series[i],children.params.PieConfig[i]);
						if(type == 'roseType' && children.params.PieConfig[i].roseType == 'radius' ){ //  南丁格尔玫瑰图-半径模式
							option.series[i].label = {normal:{show:false},emphasis:{show:true}};
							option.series[i].lableLine = {normal:{show:false},emphasis:{show: true}}
						}
					}
					for(var m=0;m<option.series[i].data.length;m++){
						if(!!option.series[i].data[m].name){ // legend
							option.legend.data.push(option.series[i].data[m].name)
						}
					}
					option.legend.data = Array.from(new Set(option.legend.data))
					if(option.series.length == 1){
						option.legend.data.splice(0,1)
					}
				}else if(catalog == 'radar'){ // 雷达图
				    if(!!data[i].name){ // 名称
						option.series[i].name = data[i].name
					}
					if(i > 0){ // 多雷达图分开
						option.series[i].radarIndex = i
					}
				    if(!option.radar[i]){ // 定义雷达图的各个点阵名称
						option.radar[i] = {indicator:[]}
					}else if(!option.radar[i].indicator){
						option.radar[i].indicator = []
					}
					var ValueArray = []
					if(data[i][obj] instanceof Array){ // 判断array
					    var radar = data[i][obj];
						option.series[i].data = [];
					    for(var k=0;k<radar.length;k++){
							ValueArray[k] = [];
							option.series[i].data[k] = {};
							for(var key in radar[k]){
								if(key == 'name'){
									option.legend.data.push(radar[k].name);
									option.series[i].data[k].name = radar[k].name
								}
								if(radar[k][key] instanceof Array){
									option.series[i].data[k].value = [];
									if(typeof(radar[k][key][0]) == 'number'){
										for(var l=0;l<radar[k][key].length;l++){
											if(!option.radar[i].indicator[l]){
												option.radar[i].indicator[l] = {}
											}
											option.series[i].data[k].value.push(parseFloat(radar[k][key][l]));
											ValueArray[k].push(parseFloat(radar[k][key][l]))
										}
									}else{
										for(var l=0;l<radar[k][key].length;l++){
											if(!option.radar[i].indicator[l]){
												option.radar[i].indicator[l] = {}
											}
											for(var m in radar[k][key][l]){
												if(typeof(radar[k][key][l][m]) == 'number'){
													option.series[i].data[k].value.push(radar[k][key][l][m]);
													ValueArray[k].push(radar[k][key][l][m])
												}else if(/^[0-9]*$/i.test(radar[k][key][l][m].toString().replace(/\s+/g, '').replace(/-/g, '').replace(/\./g,''))){
													option.series[i].data[k].value.push(parseFloat(radar[k][key][l][m]));
													ValueArray[k].push(parseFloat(radar[k][key][l][m]))
												}else if(m == 'name'){
													option.radar[i].indicator[l].name = radar[k][key][l][m]
												}
											}
										}
									}
								}
							}
						}
					}
					var t = ValueArray.length,NewArray = [];
					if(t == 1){
						NewArray = ValueArray[t-1]
					}else{
						var t1 = ValueArray[0].length,tempArray;
						for(var p=0;p<t1;p++){
							tempArray = [];
							for(var q=0;q<t;q++){
								tempArray.push(ValueArray[q][p]) // 数组的每一数列组成一个新的数组
							}
							NewArray.push(Math.max(...tempArray)) // 全部最大值组成的一个数组
						}
					}
					for(var x=0;x<NewArray.length;x++){
						var max = NewArray[x];
						if(max > 0){
							option.radar[i].indicator[x].max = max*1.25
						}else if(max < 0){
							option.radar[i].indicator[x].max = max*0.8
						}else{
							option.radar[i].indicator[x].max = max
						}
					}
				}else if(catalog == 'sankey'){ /**2018-10-24 新增桑基图方法开始**/
					console.log(option.series);
					if(type == 'simple'){ /**默认桑基图**/

					}else if(type == 'vertical'){ /**竖向桑基图**/

					}
				} /**2018-10-24 新增桑基图方法结束**/
			}
		}
		console.log(option);
		dom.setOption(option);
	},
    drillingParams:function(defaultData, drilling, myChart, isDrilling, DefaultDrilling, getDrilling){
        myChart.clear();
        if(defaultData.drilling.length > 1){
            var NewParams = {
                toolbox:{
                    feature:{
                        myBack:{
                            show: true,
                            title: '返回上一级',
                            icon: 'path://M432.45,595.444c0,2.177-4.661,6.82-11.305,6.82c-6.475,0-11.306-4.567-11.306-6.82s4.852-6.812,11.306-6.812C427.841,588.632,432.452,593.191,432.45,595.444L432.45,595.444z M421.155,589.876c-3.009,0-5.448,2.495-5.448,5.572s2.439,5.572,5.448,5.572c3.01,0,5.449-2.495,5.449-5.572C426.604,592.371,424.165,589.876,421.155,589.876L421.155,589.876z M421.146,591.891c-1.916,0-3.47,1.589-3.47,3.549c0,1.959,1.554,3.548,3.47,3.548s3.469-1.589,3.469-3.548C424.614,593.479,423.062,591.891,421.146,591.891L421.146,591.891zM421.146,591.891',
                            onclick:function (){
                                myChart.clear();
                                defaultData.data.splice(defaultData.steps,1);
                                defaultData.drilling.splice(defaultData.steps,1);
                                defaultData.steps --;
                                drilling.data = defaultData.drilling[defaultData.steps];
                                if(defaultData.steps == 0){
                                    drilling.params = DefaultDrilling.params;
                                    isDrilling = true;
                                }
                                EchartsOptionsInit.init(defaultData.catalog, defaultData.type, drilling, myChart, isDrilling);
                                EchartsOptionsInit.drillingDown(myChart, isDrilling, defaultData, getDrilling);
                                return false;
                            }
                        },
                        saveAsImage:{show:true}
                    }
                },
                legend:true
            };
            drilling.params = Object.assign(drilling.params,NewParams);
        }
        EchartsOptionsInit.init(defaultData.catalog, defaultData.type, drilling, myChart, isDrilling);
        EchartsOptionsInit.drillingDown(myChart, isDrilling, defaultData, getDrilling);
	},
    drillingDown:function(myChart, isDrilling, defaultData, getDrilling) {
        myChart.off('click');
        myChart.on('click', function (params){
            if(isDrilling){// 上钻和下钻
                //myChart.clear();
                defaultData.steps ++;
                getDrilling(defaultData, params, '')
            }else{
                console.log('不钻');
            }
        })
    },
    drillingUp:function(defaultData, drilling, myChart, isDrilling, DefaultDrilling, getDrilling){
        defaultData.data.splice(defaultData.steps,1);
        defaultData.drilling.splice(defaultData.steps,1);
        defaultData.steps --;
        drilling.data = defaultData.drilling[defaultData.steps];
        EchartsOptionsInit.drillingParams(defaultData, drilling, myChart, isDrilling, DefaultDrilling, getDrilling);
	}
};