/**
 * Created By 潘正龙 version1.0 Time:2018-09-14 13:19:00
 * Modified By 潘正龙 2018-09-14 version1.1 修改为单组件全局方法
 * Modified By 潘正龙 2018-11-06 version1.2 修改获取全局参数的方法，增加获取用户手机设备的方法
 * Modified By 潘正龙 2018-12-10 version1.3 增加ajax的请求状态，并扔出错误状态；增加ajax请求超时的错误；删除图片上传方法
**/
var pgyBase = {
    /***同步和异步CSS/JS引入***/
    Async:{
        // Type引入文件的类型,Path引入文件的路径,url引入文件的接入类型,Boolean引入文件的状态
        Load:function(Type, Path, version, url, Boolean, El){
            for(var i=0;i<pgyBase.$$$('script').length;i++){
                if(pgyBase.$$$('script')[i].getAttribute('name')==Path){
                    return false;
                }
            }
            var module = Path;
            if(Path == 'BDEcharts'){
                Path = 'https://cdn.bootcss.com/echarts/4.1.0/echarts.min.js'
            }else if(Path == 'pgyEcharts.4.1.0'){
                Path = 'modules/common/lib/pgy-components/pgy-echarts/pgy-echarts-4.1.0.js'
            }
            if(Boolean){ // false无时间戳走缓存，true有时间戳无缓存
                Path = Path+'?version='+version+'&t='+ new Date().valueOf()
            }else{
                Path = Path+'?version='+version
            }
            if(url == 'link'){ // 异步，Url引入
                pgyBase.Async.File(Type, Path, module, El)
            }else if(url == 'release'){ // 同步，释放文件到页面
                pgyBase.Async.CallBack(Type, Path, module, El)
            }
        },
        FileText:function(Type, Text, module, El){ // 同步导入内容
            if(Type=='js'){
                var script = document.createElement("script");
                script.type = "text/javascript";
                script.text = Text;
                script.setAttribute('name',module);
                El.appendChild(script);
            }else{
                var style = document.createElement('link');
                style.rel = 'stylesheet';
                style.type = 'text/css';
                style.cssText = Text;
                style.setAttribute('name',module);
                El.appendChild(style);
            }
        },
        File:function(Type, Path, module, El){ //异步导入文件
            if(Type=='js'){
                var script = document.createElement("script");
                script.type = "text/javascript";
                script.src = Path;
                script.setAttribute('name',module);
                El.appendChild(script);
            }else{
                var style = document.createElement('link');
                style.href = Path;
                style.rel = 'stylesheet';
                style.type = 'text/css';
                style.setAttribute('name',module);
                El.appendChild(style);
            }
        },
        CallBack:function(Type, Path, module, El){ // 同步加载
            var c = new XMLHttpRequest() || new ActiveXObject('Msxml2.XMLHTTP') || new ActiveXObject('Microsoft.XMLHTTP');
            c.onreadystatechange = function(){
                if(c.readyState == 4){
                    if(c.status == 200 || c.status == 304){
                        pgyBase.Async.FileText(Type, c.responseText, module, El);
                        //Async.File(Type, Path, module, El);
                    }else{
                        alert( '请求错误: ' + c.statusText + ' (' + c.status + ')' )
                    }
                }
            };
            c.open('GET', Path, false);
            c.send(null)
        }
    },
    /**通用选择器**/
    $:function (selector) { return document.querySelector(selector) },
    $$:function (selector) { return document.querySelectorAll(selector) },
	errorStatus:[400,401,403,404,500,503],
    HostUrl:window.location.origin + '/bof_operation/rest/v11/',
    /**新定义无TOKEN AJAX数据请求办法**/
    Ajax:function(RequestAsync, RequestType, URL, do_result, Params){
		var c = new XMLHttpRequest() || new ActiveXObject('Msxml2.XMLHTTP') || new ActiveXObject('Microsoft.XMLHTTP'), e = new Date().valueOf();
		if (URL.indexOf('?') != -1) {
			URL = URL + '&t=' + e
		}else{
			URL = URL + '?t=' + e
		}
		c.open(RequestType, URL, RequestAsync); // true异步模式，false同步模式
		c.onreadystatechange = function (){
			if(c.readyState == 4) {
				if(c.status == 200){
					console.log('4.正常获取数据，返回数据和回调');
					do_result(JSON.parse(c.responseText));
					return false;
				}else{
					console.log('4.请求出错，扔出错误码');
					var status = false;
					for(var i=0;i<pgyBase.errorStatus.length;i++){
						if(c.status == pgyBase.errorStatus[i]){
							status = pgyBase.errorStatus[i];
						}
					}
					if(!!status){
						alert('请求状态'+status+'，请联系客服！');
					}else{
						alert('未获取到请求状态，请联系客服！');
					}
					return false;
				}
				setTimeout(function(){
					c.abort(); // 取消ajax请求，c.readyState = 0;
					alert('数据请求超时，请重新尝试！');
				},15000);
			}else if(c.readyState == 2){
				console.log('2.ajax请求成功，send数据开始');
			}else if(c.readyState == 3){
				console.log('3.已经接收到HTTP响应头部信息，但是消息体部分还没有完全接收到');
			}
		}
		if(RequestType == 'PUT'){ // 浏览器原生支持Content-Type
			c.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
			c.send(JSON.stringify(Params));
		}else if (RequestType == 'GET') {
			c.send(null);
		}else if(RequestType == 'POST') {
			c.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
			c.send(JSON.stringify(Params));
		}
	},
	/**全局ICONLIST**/
	AIconList:{error:'&#xe602;',ok:'&#xe659;',notice:'&#xe60c;',alert:'&#xe64f;',success:'&#xe607;',q:'&#xe657;'},
	CloseTime:1500,
	/**自定义alert弹窗**/
	$message:function(message){
		var vm = this, messagetag = 1, timer = pgyBase.CloseTime, html = '', icon = '';
		for(var item in pgyBase.AIconList){
			if(item == message.type){
				icon = pgyBase.AIconList[item];
			}
		}
		if(!!pgyBase.$('#Anotice')){ // 已存在弹窗
			messagetag ++
			html += '<dl class="Anotice mflex"><dt class="iconfont">'+icon+'</dt><dd class="d1">'+message.message+'</dd></dl>';
			pgyBase.$('#Anotice').innerHTML = html;
			RemoveAnotice(messagetag ++,messagetag --)
		}else{ // 不存在弹窗
			html += '<dl class="Anotice mflex animation FSH"><dt class="iconfont">'+icon+'</dt><dd class="d1">'+message.message+'</dd></dl>';
			var section = document.createElement('section');
			section.id = 'Anotice';
			section.className = 'mflex';
			section.innerHTML = html;
			var s = document.getElementsByTagName("script")[0]; 
			pgyBase.$('body').insertBefore(section, s);
			RemoveAnotice(messagetag ,messagetag --);
		}
		function RemoveAnotice(id,tag){
			setTimeout(function(){
				if(!!pgyBase.$('#Anotice') && tag >= id){
					pgyBase.$('#Anotice').remove();
				}
			}, timer);
		}
	},
	/**自定义confirm弹窗**/
	$confirm:function(message){
		var html = '', icon = '';
		for(var item in pgyBase.AIconList){
			if(item == message.type){
				icon = pgyBase.AIconList[item];
			}
		}
		html += '<dl class="Anotice mflex FSB">'+
					'<dt class="iconfont">'+icon+'</dt>'+
					'<dd class="d1">'+message.message+'</dd>'+
					'<dd class="d2 flex">'+
						'<i class="flex float_left cancel" onclick="handleACancel()">'+message.cancelButtonText+'</i>'+
						'<i class="flex float_right confirm" onclick="handleAConfirm()">'+message.confirmButtonText+'</i>'+
					'</dd>'+
				'</dl>';
		var section = document.createElement('section');
		section.id = 'Anotice';
		section.className = 'mflex';
		section.innerHTML = html;
		var s = document.getElementsByTagName("script")[0];
		pgyBase.$('body').insertBefore(section, s);
	},
    /**异步引入css文件**/
    LinkCss:function (path, parent) {
        var link = document.createElement('link');
        link.href = path+'?t='+(new Date()).valueOf();
        link.rel = 'stylesheet';
        link.type = 'text/css';
        pgyBase.$$(parent).append(link);
    },
    /**定义时间戳转年月日**/
    FormatDate:function (date, fmt) { //this.Format(this.TempList[i].createTime,'yyyy-MM-dd hh:mm:ss')
        var o = {
            "M+": new Date(date).getMonth() + 1, //月份
            "d+": new Date(date).getDate(), //日
            "h+": new Date(date).getHours(), //小时
            "m+": new Date(date).getMinutes(), //分
            "s+": new Date(date).getSeconds(), //秒
            "q+": Math.floor((new Date(date).getMonth() + 3) / 3), //季度
            "S": new Date(date).getMilliseconds() //毫秒
        };
        if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (new Date(date).getFullYear() + "").substr(4 - RegExp.$1.length))
        for (var k in o)
            if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)))
        return fmt
    },
    /**定义保留两位小数**/
    ReturnFloat:function (value){ // 数字转化
        var newvalue = Math.round(parseFloat(value)*100)/100
        var MathValue = newvalue.toString().split(".")
        if(MathValue.length==1){
            value=value.toString()+".00"
            return value
        }
        if(MathValue.length>1){
            if(MathValue[1].length<2){
                value=value.toString()+"0"
            }
            return value
        }
    },
    /**获取URL参数**/
    getURLParam:function (parameter, Back) {
		var l = '', j = Back.replace(/&/g,'?').split('?');
		for (var p = 0; p < j.length; p++) {
			if (j[p].indexOf(parameter + '=') === 0) {
				var i = j[p].split('=');
				l = i[1];
				break
			}
		}
		return l;
    },
    /**Input验证**/
    VeryFy:function (name, type, notice) {
        var vm = this
        var go = true
        if (type == 'tel') { // 手机号码
            name = name.replace(/\s+/g, '').replace(/-/g, '')
            if(name.length < 11){
                vm.$message({
                    message: notice,
                    type: 'error'
                })
                go = false
            }else if(!(/^1[3|4|5|7|8|9][0-9]\d{4,8}$/.test(name)) && name.length > 0 || name.length > 11) {
                vm.$message({
                    message: notice,
                    type: 'error'
                })
				 go = false
            }
        }else if(type == 'num') { // 数字类型
            name = name.replace(/\s+/g, '').replace(/-/g, '')
            if(!(/^[0-9]*$/i.test(name)) && name.length > 0) {
                vm.$message({
                    message: notice,
                    type: 'error'
                })
                go = false
            }
        }else if(type == 'int') {//正整数
            name = name.toString().replace(/\s+/g, '').replace(/-/g, '')
            if(!(/^([1-9][0-9]*)$/.test(name))) {
                vm.$message({
                    message: notice,
                    type: 'error'
                })
                go = false
            }
        }else if(type == 'long') {//正数
            name = name.replace(/\s+/g, '').replace(/-/g, '')
            if(!(/^[0](\\.[0-9]*)|[1-9][0-9]*(\\.[0-9]*)?$/.test(name))) {
                vm.$message({
                    message: notice,
                    type: 'error'
                })
                go = false
            }
        } else if(type == 'extand') {//数字和字母
            name = name.replace(/\s+/g, '').replace(/-/g, '')
            if(!(/^[A-Za-z0-9]+$/.test(name))) {
                vm.$message({
                    message: notice,
                    type: 'error'
                })
                go = false
            }
        } else if(type == 'email') { // 邮箱
            if(!(/^([a-zA-Z0-9]+[_|\_|\.]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[_|\_|\.]?)*[a-zA-Z0-9]+\.[a-zA-Z]{2,3}$/.test(name))) {
                vm.$message({
                    message: notice,
                    type: 'error'
                })
                go = false
            }
        }else if(type == 'pwd') { // 密码
            if(!(/^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{7,16}$/.test(name))) {
                vm.$message({
                    message: notice,
                    type: 'error'
                })
                go = false
            }
        }else if(type == 'cvv2'){ // CVV2码
            if(!(/^[0-9]*$/i.test(name))) {
                vm.$message({
                    message: notice,
                    type: 'error'
                })
                go = false
            }
        }else if(type == 'validity'){ // 卡有效期
            if(!(/^[0-9]*$/i.test(name))) {
                vm.$message({
                    message: notice,
                    type: 'error'
                })
                go = false
            }else if(parseInt(name.substr(0,2)) > 12){
                vm.$message({
                    message: notice,
                    type: 'error'
                })
                go = false
            }
        }else if(type == 'chinesename'){ // 中文
			if (!/^[\u4e00-\u9fa5]+$/.test(name)) {
				vm.$message({
                    message: notice,
                    type: 'error'
                })
                go = false
			}
		}else if(type == '15IdCard'){ //身份证正则表达式(15位)
			if (!/^[1-9]\d{5}\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\d{2}$/.test(name)) {
				vm.$message({
                    message: notice,
                    type: 'error'
                })
                go = false
			}
		}else if(type == '18IdCard'){ //身份证正则表达式(18位)
			if (!/^[1-9]\d{5}(18|19|([23]\d))\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\d{3}[0-9Xx]$/.test(name)) {
				vm.$message({
                    message: notice,
                    type: 'error'
                })
                go = false
			}
		}
		return go
    },
    /**比较两个数字或者日期的大小,num1 > num2为false**/
    Validate:function (num1, num2, type, notice) {
        var vm = this
        var go = true
        if (type === 'num') {
            if (num1 > num2) {
                vm.$message({
                    message: notice,
                    type: 'error'
                })
                go = false
            }
        } else if (type === 'date') {
            if (num1 > num2) {
                vm.$message({
                    message: notice,
                    type: 'error'
                })
                go = false
            }
        }
        return go
    },
    /**定义两个object比较方法**/
    ObjEqual:function (a, b) {
        if (a == b)
            return true
        if (typeof(b) == "undefined" || b == null || typeof(b) != "object")
            return false
        var length = 0, length1 = 0
        for (var ele in a) {
            length++
        }
        for (var ele in b) {
            length1++
        }
        if (length != length1)
            return false
        if (b.constructor == a.constructor) {
            for (var ele in a) {
                if (typeof(a[ele]) == "object") {
                    if (!a[ele].equals(b[ele])) {
                        return false
                    }
                } else if (typeof(a[ele]) == "function") {
                    if (!a[ele].toString().equals(b[ele].toString())) {
                        return false
                    }
                } else if (a[ele] != b[ele]) {
                    return false
                }
            }
            return true
        }
        return false
    },
    /**对象转换为字符串**/
    Obj2String:function (Obj){
        var string = '', t = 0, NewObj = JSON.parse(JSON.stringify(Obj));
        for(var p in NewObj){
            if(!!NewObj[p]){
                t++;
                if(t==1){
                    string += '?'
                }else{
                    string += '&'
                }
                string += p + '='+ NewObj[p]
            }
        };
        return string;
    },
	/**获取设备的基本信息**/
	getEpuipmentInfo:function(time){
		var UA = navigator.userAgent.toLocaleLowerCase();
		var UAList = UA.split(' '), t1 = UA.indexOf('('), t2 = UA.indexOf(')');
		/**获取微信版本，获取网络类型**/
		for(var j=0;j<UAList.length;j++){
			if(UAList[j].indexOf('micromessenger') > -1){
				sessionStorage.wxVersion = UAList[j]
			}
			if(UAList[j].indexOf('nettype') > -1){
				sessionStorage.netType = UAList[j].split('/')[1]
			}
		}
		var MList = UA.substr(t1, t2-t1).replace(/\(|\)|\?/g,'').split(';');
		/**安卓设备**/
		if(UA.indexOf("android") > -1 || UA.indexOf("linux") > -1){
			for(var i=0;i<MList.length;i++){
				if(MList[i].indexOf('android') > -1){
					sessionStorage.equipmentOS = MList[i];
				}
				if(MList[i].indexOf('build') > -1){
					sessionStorage.equipmentOEM = MList[i];
				}
			}
		/**IOS设备**/
		}else if(!!UA.match(/\(i[^;]+;( U;)? cpu.+mac os x/)){
			var t1 = UA.indexOf('('), t2 = UA.indexOf(')');
			var MList = UA.substr(t1, t2-t1).replace(/\(|\)|\?/g,'').split(';');
			sessionStorage.equipmentOEM = 'Apple ' + MList[0];
			sessionStorage.equipmentOS = 'IOS '+ MList[1].slice(MList[1].indexOf('os')+3,MList[1].indexOf('like')-1).replace(/\*|\_|\?/g,".");
		}
		sessionStorage.cTime = pgyBase.FormatDate(time, 'yyyy-MM-dd hh:mm:ss');
	}
};